<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TV Show Banner</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            overflow: hidden;
            background-image: url('https://i.pinimg.com/originals/16/03/fb/1603fb7077abb9093f4af305b4e5ce79.gif'); /* Replace 'your_background.gif' with the URL of your GIF */
            background-size: cover;
            background-repeat: no-repeat;
        }

        .banner-container {
            width: 100%;
            overflow-x: hidden; /* Hide the horizontal scrollbar */
            white-space: nowrap;
            padding-bottom: 10px; /* Add some space below the banner */
            scroll-behavior: smooth; /* Enable smooth scrolling */
            margin-bottom: -10px; /* Adjust for padding */
        }

        .tv-poster {
            width: auto;
            max-height: 100vh; /* Adjust the maximum height of posters */
            margin-right: 2px; /* Adjust the spacing between posters */
        }
    </style>
</head>
<body>
    <div class="banner-container" id="tv-banner">
        <!-- TV show posters will be added here dynamically -->
    </div>

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2'; // Replace with your TMDb API key
        let tvShowIds = [];
        let scrollInterval;

        async function fetchPopularTVShowIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/tv?api_key=${apiKey}&sort_by=popularity.desc`);
                const data = await response.json();
                tvShowIds = data.results.map(tvShow => tvShow.id);
            } catch (error) {
                console.error(error);
            }
        }

        async function updateTVBanner() {
            if (tvShowIds.length === 0) {
                console.error('Failed to fetch TV show IDs.');
                return;
            }

            const tvShowId = tvShowIds.shift();

            fetch(`https://api.themoviedb.org/3/tv/${tvShowId}?api_key=${apiKey}`)
                .then((response) => response.json())
                .then((data) => {
                    const tvBanner = document.getElementById('tv-banner');
                    const posterPath = `https://image.tmdb.org/t/p/original${data.poster_path}`;
                    const tvPoster = document.createElement('img');
                    tvPoster.src = posterPath;
                    tvPoster.alt = data.name;
                    tvPoster.className = 'tv-poster';
                    tvBanner.appendChild(tvPoster);
                    tvShowIds.push(tvShowId); // Add the TV show ID back to the end of the array for continuous scrolling
                })
                .catch((error) => console.error(error));
        }

        fetchPopularTVShowIds().then(() => {
            // Set an interval to add TV show posters every few seconds
            scrollInterval = setInterval(updateTVBanner, 2000); // Adjust the interval here (milliseconds)
            
            // Set an interval to automatically scroll the banner
            setInterval(() => {
                const bannerContainer = document.getElementById('tv-banner');
                bannerContainer.scrollLeft += 6; // Adjust the scrolling speed as needed
            }, 50); // Adjust the interval for smoother or faster scrolling
        });
    </script>
</body>
</html>
